/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.entities.model.ai.goals.pathfinding;

import com.badlogic.gdx.ai.msg.MessageDispatcher;
import com.badlogic.gdx.math.Vector2;
import technology.rocketjump.undermount.entities.model.Entity;
import technology.rocketjump.undermount.entities.model.ai.goals.Goal;
import technology.rocketjump.undermount.entities.model.ai.goals.pathfinding.WaitForPathfindingGoal;
import technology.rocketjump.undermount.mapping.model.TiledMap;
import technology.rocketjump.undermount.messaging.types.PathfindingRequestMessage;

public class RequestPathfindingGoal
extends Goal {
    private final Vector2 destination;
    private final MessageDispatcher messageDispatcher;
    private final TiledMap map;
    private boolean pathfindingRequested;

    public RequestPathfindingGoal(Entity parentEntity, Goal parentGoal, Vector2 destination, MessageDispatcher messageDispatcher, TiledMap map) {
        super(parentEntity, parentGoal);
        this.destination = destination;
        this.messageDispatcher = messageDispatcher;
        this.map = map;
    }

    @Override
    public void update(float deltaTimeSeconds) {
        WaitForPathfindingGoal waitForPathfindingGoal = new WaitForPathfindingGoal(this.parentEntity, this.parentGoal, this.map);
        PathfindingRequestMessage pathfindingRequestMessage = new PathfindingRequestMessage(this.parentEntity.getLocationComponent().getWorldPosition(), this.destination, this.map, waitForPathfindingGoal, this.parentEntity.getId());
        this.parentGoal.getChildGoals().addLast(waitForPathfindingGoal);
        this.messageDispatcher.dispatchMessage(null, 400, (Object)pathfindingRequestMessage);
        this.pathfindingRequested = true;
    }

    @Override
    public boolean isComplete() {
        return this.pathfindingRequested;
    }
}

